#ifndef QRFEGS1TAGIDFACTORY_H
#define QRFEGS1TAGIDFACTORY_H

#include <QString>
#include <QByteArray>
#include "QrfeTagId.h"

class QrfeGS1TagIdFactory
{
public:
    static QrfeTagId* parseTagId(const QByteArray &epc);

public:
    static QrfeTagId* parse_GDTI_96(const QByteArray &epc);
    static QrfeTagId* parse_GSRN_96(const QByteArray &epc);
    static QrfeTagId* parse_USDoD_96(const QByteArray &epc);
    static QrfeTagId* parse_SGTIN_96(const QByteArray &epc);
    static QrfeTagId* parse_SSCC_96(const QByteArray &epc);
    static QrfeTagId* parse_SGLN_96(const QByteArray &epc);
    static QrfeTagId* parse_GRAI_96(const QByteArray &epc);
    static QrfeTagId* parse_GIAI_96(const QByteArray &epc);
    static QrfeTagId* parse_GID_96(const QByteArray &epc);
    static QrfeTagId* parse_SGTIN_198(const QByteArray &epc);
    static QrfeTagId* parse_GRAI_170(const QByteArray &epc);
    static QrfeTagId* parse_GIAI_202(const QByteArray &epc);
    static QrfeTagId* parse_SGLN_195(const QByteArray &epc);
    static QrfeTagId* parse_GDTI_113(const QByteArray &epc);
    static QrfeTagId* parse_ADI_var(const QByteArray &epc);

public:
    static QString getTagIdString(const QByteArray &epc);
};

#endif // QRFEGS1TAGIDFACTORY_H
